/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define("@angular/compiler-cli/src/ngtsc/reflection/src/host", ["require", "exports"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    /**
     * An enumeration of possible kinds of class members.
     */
    var ClassMemberKind;
    (function (ClassMemberKind) {
        ClassMemberKind[ClassMemberKind["Constructor"] = 0] = "Constructor";
        ClassMemberKind[ClassMemberKind["Getter"] = 1] = "Getter";
        ClassMemberKind[ClassMemberKind["Setter"] = 2] = "Setter";
        ClassMemberKind[ClassMemberKind["Property"] = 3] = "Property";
        ClassMemberKind[ClassMemberKind["Method"] = 4] = "Method";
    })(ClassMemberKind = exports.ClassMemberKind || (exports.ClassMemberKind = {}));
    /**
     * Possible functions from TypeScript's helper library.
     */
    var TsHelperFn;
    (function (TsHelperFn) {
        /**
         * Indicates the `__spread` function.
         */
        TsHelperFn[TsHelperFn["Spread"] = 0] = "Spread";
    })(TsHelperFn = exports.TsHelperFn || (exports.TsHelperFn = {}));
});
//# sourceMappingURL=data:application/json;base64,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