﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using SDBWebAPI.Models;
using SDBWebAPI.ModelsDTO;
using SDBWebAPI.Services.Interfaces;

namespace SDBWebAPI.Controllers
{
    [Produces("application/json")]
    public class UserController : Controller
    {
        private readonly IUserService userService;

        public UserController(IUserService userService)
        {
            this.userService = userService;
        }

        [Route("api/user/getAllUsers")]
        [HttpGet]
        public UsersDTO GetAllUsers()
        {
            return userService.GetAllUser();
        }

        [Route("api/user/login/{email}/{password}")]
        [HttpGet]
        public ResponseDTO Login(string email, string password)
        {
            var result = userService.Login(email, password);
            return result;
        }

        [Route("api/user/register")]
        [HttpPost]
        public ResponseDTO Register([FromBody]User user)
        {
            var result = userService.Register(user);
            return result;
        }
    }
}