using System;
using System.Collections;
using System.IO;
using System.Resources;

class Program
{
    static void Main(string[] args)
    {
        string resXFile = args[0];
        string resKey = args[1];
        string resValueFile = args[2];

        using (ResXResourceWriter writer = new ResXResourceWriter(resXFile))
        {
            Console.WriteLine("Kojarz {0} z zawartoci {1}",
                resKey, resValueFile);
            Console.Write("Do {0}...", resXFile);

            // Klonujemy istniejc tre:
            using (ResXResourceReader reader =
                new ResXResourceReader(resXFile))
            {
                foreach (DictionaryEntry node in reader)
                    writer.AddResource((string)node.Key, node.Value);
            }

            // A teraz po prostu dodajemy nowy klucz:
            writer.AddResource(resKey, File.ReadAllBytes(resValueFile));
        }

        Console.WriteLine("gotowe.");
    }
}