﻿using System;
using System.Reflection;
using System.Threading;

namespace Wrox.DotNetFramework2.Samples
{
    class Program
    {
        public static void Main(string[] args)
        {
            
            string chapter;
            if (args.Length == 0)
            {
                Console.Write("Wpisz numer rozdziału: ");
                chapter = Console.ReadLine();
                if (chapter == null || chapter.Trim().Equals(string.Empty))
                {
                    Console.WriteLine("Użycie: Wrox20 <nr rozdziału> [<nr przykładu>]");
                    return;
                }
            }
            else
            {
                chapter = args[0];
            }

            chapter = chapter.PadLeft(2, '0');

            Type t = Type.GetType("Wrox.DotNetFramework2.Samples.Chapter" + chapter);
            if (t == null)
            {
                Console.WriteLine("Błąd: nie znaleziono rozdziału {0}.; wpisz liczbę z zakresu 1 - 15.", chapter);
                return;
            }

            string filt = null;
            if (args.Length > 1)
                filt = args[1];

            MethodInfo[] mi = t.GetMethods(BindingFlags.Static | BindingFlags.Public);
            Array.Sort(mi, delegate(MethodInfo m1, MethodInfo m2) { return m1.Name.CompareTo(m2.Name); });
            foreach (MethodInfo m in mi)
            {
                if ((m.Name.StartsWith("ex") || m.Name.StartsWith("_")) &&
                    (filt == null || m.Name.EndsWith(filt)))
                {
                    Console.ForegroundColor = ConsoleColor.Cyan;
                    Console.WriteLine("----- test {0}:{1} -----", chapter, m.Name);
                    Console.ResetColor();
                    try
                    {
                        m.Invoke(null, null);
                    }
                    catch (Exception ex)
                    {
                        // Jeśli pojawi się wyjątek przerwania wątku, przechwytujemy go i anulujemy
                        if (ex is ThreadAbortException)
                            Thread.ResetAbort();
                        Console.WriteLine("Przechwycono wyjątek: {0}", ex.InnerException.ToString());
                    }
                    Console.WriteLine();
                }
            }
        }

    }

}
