# Rozdział 2. - Laboratorium - Przykładowe rozwiązanie

1. Uruchom kontener aplikacji internetowej z przykładów przedstawionych w treści rozdziału:

```
> docker container run --detach --publish 8088:80 diamol/ch02-hello-diamol-web
86b20cd8e846d7ea8cf29d08d8c22118f925cca818ab28765d218c7585dbc52d
```

> Zanotuj początekowy fragment identyfikatora uruchomionego kontenera, tak byś mógł wykonywać na nim operacje. W przedsatwionym przykładzie będzie to '86b'.

2. _[Opcjonalnie]_ Sprawdź czy strona WWW w kontenerze znajduje się w oczekiwanym miejscu:

- w przypadku kontenerów z systemem Linux użyj polecenia `ls`:

```
> docker container exec 86b  ls /usr/local/apache2/htdocs
index.html
```

- w przypadku kontenerów z systemem Windows użyj polecenia `dir`, jednak musisz je wykonać przy użyciu polecenia `cmd`, jak na poniższym przykładzie:

```
docker container exec 86b cmd /s /c dir C:\usr\local\apache2\htdocs
index.html
```

3. Wiemy gdzie w kontenerze znajduje się plik HTML, więc możemy użyć polecenia `docker container cp`, by skopiować lokalny plik do kontenera. W ten sposób możemy nadpisać plik `index.html` w kontenerze zastępując go plikem z lokalnego katalogu:


```
docker container cp index.html 86b:/usr/local/apache2/htdocs/index.html
```

Polecenie `cp` ma następujący format: `[ścieżka źródłowa] [ścieżka docelowa]`. Kontener może być zarówno źródłem z którego plik jest kopiowany, jak również miejscem docelowym operacji kopiowania; przy czym ścieżkę dostępu do pliku na kontenerze należy poprzedzić identyfikatorem kontenera (w powyższym przykładzie jest to ciąg znaków `86b`). Tego samego sposobu zapisu ścieżki, z ukośnikami, można używać w polecaniach `cp` ww kontenerach z systemem Linux oraz z systemem Windows.

> Jeśli używasz kontenerów z systemem Windows w systemie Windows 10, to może wystąpić błąd _operacje na systemie plików wykonywane na działającym kontenerze Hyper-V, nie są obsługiwane_, co oznacza, że przed wykonaniem polecenia `docker container cp` muisz zatrzymać kontener używając polecenia `docker container stop <id>`, a po skopiowaniu pliku ponownie ten kontener uruchomić poleceniem `docker container start <id>`.

4. Aby wyświetlić nowe treści w przeglądarce, użyj opublikowanego portu: http://localhost:8088:

![](new-website.png)

## Uwaga

Działający w kontenerze serwera Apache zwraca plik HTML umieszczony w określonym, znanym miejscu. Wykonując opisane powyżej czynności przesłoniliśmy plik umieszczony w kontenerze nowym plikiem skopiowanym z lokalnego komputera i teraz serwer Apache będzie udostępniał skopiowany, nowy plik.

Jednak wykonując te czynności nie zmieniliśmy pliku umieszczonego w obrazie Dockera. Jeśli usuniesz ten kontener i uruchomisz, to będzie on udostępniał pierwotny plik HTML.
