package r10;

import javax.swing.*;
import java.awt.*;

/**
 * A simple demo of several label options with variations
 * on color, alignment, and icons.
 */
public class Labels {

    // To make this simple example run from inside an IDE like IntelliJ IDEA,
    // set this path to match where you unzipped the book's projects.
    static final String PROJECT_PATH = "/Users/work/LearningJava5e";

    public static void main( String[] args ) {
        JFrame frame = new JFrame( "Przykady JLabel" );
        frame.setLayout(new FlowLayout());
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setSize( 300, 300 );

        JLabel basic = new JLabel("Etykieta domylna");
        basic.setOpaque(true);
        basic.setBackground(Color.YELLOW);
        JLabel another = new JLabel("Kolejna etykieta");
        another.setOpaque(true);
        another.setBackground(Color.GREEN);
        JLabel simple = new JLabel("Prosta etykieta");
        simple.setOpaque(true);
        simple.setBackground(Color.WHITE);
        JLabel standard = new JLabel("Standardowa etykieta");
        standard.setOpaque(true);
        standard.setBackground(Color.ORANGE);
        JLabel centered = new JLabel("Tekst wyrodkowany", JLabel.CENTER);
        centered.setPreferredSize(new Dimension(150, 24));
        centered.setOpaque(true);
        centered.setBackground(Color.WHITE);
        JLabel times = new JLabel("Times Roman");
        times.setOpaque(true);
        times.setBackground(Color.WHITE);
        times.setFont(new Font("TimesRoman", Font.BOLD, 18));
        JLabel styled = new JLabel("<html>Uycie <b><i>stylw</i></b> rwnie dozwolone</html>");
        styled.setOpaque(true);
        styled.setBackground(Color.WHITE);
        JLabel icon = new JLabel("Zweryfikowano", new ImageIcon(PROJECT_PATH + "/r10/check.png"), JLabel.LEFT);
        icon.setOpaque(true);
        icon.setBackground(Color.WHITE);

        frame.add(basic);
        frame.add(another);
        frame.add(simple);
        frame.add(standard);
        frame.add(centered);
        frame.add(times);
        frame.add(styled);
        frame.add(icon);

        frame.setVisible( true );
    }
}
