#!/usr/bin/perl
# cgiskel.pl - Szkielet skryptu CGI (używany jest interfejs wywołania funkcji CGI.pm).
#@ _PREAMBLE_

use strict;
use warnings;
use DBI;
#@ _USE_CGI_
use CGI qw(:standard);
#@ _USE_CGI_

use Cwd;
# Plik opcji, który w systemie UNIX powinien zawierać parametry połączenia.
my $option_file = "/usr/local/apache/conf/sampdb.cnf";
my $option_drive_root;
# Nadpisanie położenia pliku w przypadku systemu Windows.
if ($^O =~ /^MSWin/i || $^O =~ /^dos/)
{
  $option_drive_root = "C:/";
  $option_file = "/Apache/conf/sampdb.cnf";
}

# Przygotowanie źródła danych i nawiązanie połączenia z serwerem (w systemie Windows trzeba
# najpierw zachować nazwę bieżącego katalogu roboczego, przejść do dysku zawierającego plik
# opcji, nawiązać połączenie, a następnie powrócić do zapisanego katalogu bieżącego).
my $orig_dir;
if (defined ($option_drive_root))
{
  $orig_dir = cwd ();
  chdir ($option_drive_root)
    or die "Nie można przejść do dysku $option_drive_root: $!\n";
}
my $dsn = "DBI:mysql:sampdb;mysql_read_default_file=$option_file";
my %conn_attrs = (RaiseError => 1, PrintError => 0, AutoCommit => 1);
my $dbh = DBI->connect ($dsn, undef, undef, \%conn_attrs);
if (defined ($option_drive_root))
{
  chdir ($orig_dir)
    or die "Nie można przejść do katalogu $orig_dir: $!\n";
}
#@ _PREAMBLE_

#@ _MAIN_BODY_
my $title = "Tytuł strony";

print header ();
print start_html (-title => $title, -bgcolor => "white");

#@ _HEADER1_
print h1 ("To jest nagłówek");
#@ _HEADER1_
#@ _PARA_
print p ("To jest akapit");
#@ _PARA_

# ... wygenerowanie pozostałej części dokumentu ...

print end_html ();
#@ _MAIN_BODY_

$dbh->disconnect ();
