#!/usr/bin/perl
# show_member.pl - Skrypt wyświetla rekord członka Ligi Historycznej.

# Użycie: show_member [ member_number | last_name ]

# Argument last_name może być wzorcem SQL.

use strict;
use warnings;
use DBI;

@ARGV or die "Użycie: show_member [ member_number | last_name ]\n";

# Przyjmuje się założenie, że informacje o komputerze, użytkowniku i haśle będą pobrane z pliku opcji.

my $dsn = "DBI:mysql:sampdb;mysql_read_default_group=client";
my %conn_attrs = (RaiseError => 1, PrintError => 0, AutoCommit => 1);
my $dbh = DBI->connect ($dsn, undef, undef, \%conn_attrs);

#@ _MAIN_BODY_
my $count = 0;  # Liczba wyświetlonych dotąd wierszy.
my @label = (); # Tablica etykiet kolumn.
my $label_wid = 0;

while (@ARGV)   # Wykonanie zapytania dla każdego argumentu wiersza poleceń.
{
  my $arg = shift (@ARGV);

  # Domyślnym wzorcem jest wyszukiwanie po nazwisku...
  my $clause = "last_name LIKE " . $dbh->quote ($arg);
  # ...ale po podaniu argumentu liczbowego wyszukiwanie odbywa się po identyfikatorze.
  $clause = "member_id = " . $dbh->quote ($arg) if $arg =~ /^\d+$/;

  # Wykonanie zapytania.
  my $sth = $dbh->prepare (qq{
              SELECT * FROM member
              WHERE $clause
              ORDER BY last_name, first_name
            });
  $sth->execute ();

  # Pobranie nazw kolumn używanych jako etykiety oraz określenie
  # maksymalnej długości nazwy kolumny w celu jej sformatowania
  # (ta operacja jest przeprowadzana tylko w trakcie pierwszej iteracji pętli).
  if ($label_wid == 0)
  {
    @label = @{$sth->{NAME}};
    foreach my $label (@label)
    {
      $label_wid = length ($label) if $label_wid < length ($label);
    }
  }

  # Odczyt i wyświetlenie wyników zapytania.
  my $matches = 0;
  while (my @ary = $sth->fetchrow_array ())
  {
    # Wstawienie znaku nowego wiersza przed drugim i kolejnym wierszem danych wyjściowych.
    print "\n" if ++$count > 1;
    foreach (my $i = 0; $i < $sth->{NUM_OF_FIELDS}; $i++)
    {
      # Wyświetlenie etykiety.
      printf "%-*s", $label_wid+1, $label[$i] . ":";
      # Wyświetlenie wartości, o ile jest dostępna.
      print " ", $ary[$i] if defined ($ary[$i]);
      print "\n";
    }
    ++$matches;
  }
  print "\nNie znaleziono dopasowań dla \"$arg\"\n" if $matches == 0;
}
#@ _MAIN_BODY_

$dbh->disconnect ();
