#!/usr/bin/perl
# interests.pl - Wyszukanie członków Ligi Historycznej do danych zainteresowaniach,
# operacja przeprowadzona przez sprawdzenie wartości kolumny interests tabeli member.

use strict;
use warnings;
use DBI;

# Przetworzenie parametrów z wiersza poleceń, o ile zostały podane.

use Getopt::Long;
$Getopt::Long::ignorecase = 0; # Wielkość liter w opcjach ma znaczenie.
$Getopt::Long::bundling = 1;   # -uname = -u name, a nie -u -n -a -m -e

# Parametry domyślne, wszystkie początkowo niezdefiniowane.
my ($host_name, $password, $port_num, $socket_name, $user_name);

GetOptions (
  # =i oznacza, że po opcji trzeba podać wartość w postaci liczby całkowitej.
  # =s oznacza, że po opcji trzeba podać wartość w postaci ciągu tekstowego.
  "host|h=s"      => \$host_name,
  "password|p=s"  => \$password,
  "port|P=i"      => \$port_num,
  "socket|S=s"    => \$socket_name,
  "user|u=s"      => \$user_name
) or exit (1);

# Utworzenie źródła danych.
my $dsn = "DBI:mysql:sampdb";
$dsn .= ";host=$host_name" if $host_name;
$dsn .= ";port=$port_num" if $port_num;
$dsn .= ";mysql_socket=$socket_name" if $socket_name;
$dsn .= ";mysql_read_default_group=client";

# Nawiązanie połączenia z serwerem.
my %conn_attrs = (RaiseError => 1, PrintError => 0, AutoCommit => 1);
my $dbh = DBI->connect ($dsn, $user_name, $password, \%conn_attrs);

#@ _MAIN_BODY_
@ARGV or die "Użycie: interests.pl keyword\n";
search_members (shift (@ARGV)) while @ARGV;
#@ _MAIN_BODY_

$dbh->disconnect ();

#@ _SEARCH_MEMBERS_
sub search_members
{
my $interest = shift;

  print "Wyniki wyszukiwania dla słowa kluczowego: $interest\n\n";
  my $sth = $dbh->prepare (qq{
              SELECT * FROM member WHERE interests LIKE ?
              ORDER BY last_name, first_name
            });
  # Wyszukanie ciągu tekstowego w dowolnym miejscu kolumny interest.
  $sth->execute ("%" . $interest . "%");
  my $count = 0;
  while (my $hash_ref = $sth->fetchrow_hashref ())
  {
    format_entry ($hash_ref);
    ++$count;
  }
  print "Liczba dopasowanych rekordów: $count\n\n";
}
#@ _SEARCH_MEMBERS_

sub format_entry
{
my $entry_ref = shift;

  printf "Imię i nazwisko: %s\n", format_name ($entry_ref);
  my $address = "";
  $address .= $entry_ref->{street} if $entry_ref->{street};
  $address .= ", " . $entry_ref->{city} if $entry_ref->{city};
  $address .= ", " . $entry_ref->{state} if $entry_ref->{state};
  $address .= " " . $entry_ref->{zip} if $entry_ref->{zip};
  print "Adres: $address\n" if $address;
  print "Telefon: $entry_ref->{phone}\n" if $entry_ref->{phone};
  print "E-mail: $entry_ref->{email}\n" if $entry_ref->{email};
  print "Zainteresowania: $entry_ref->{interests}\n"
              if $entry_ref->{interests};
  print "\n";
}

sub format_name
{
my $entry_ref = shift;

  my $name = $entry_ref->{first_name} . " " . $entry_ref->{last_name};
  if (defined ($entry_ref->{suffix}))     # Istnieje przyrostek dla nazwiska.
  {
    # Brak przecinka w przyrostkach typu I, II, III itd.
    $name .= "," unless $entry_ref->{suffix} =~ /^[IVX]+$/;
    $name .= " " . $entry_ref->{suffix}
  }
  return ($name);
}
