void
summary_stats (MYSQL_RES *res_set, unsigned int col_num)
{
MYSQL_FIELD   *field;
MYSQL_ROW     row;
unsigned int  n, missing;
double        val, sum, sum_squares, var;

  /* Weryfikacja wymagań dotyczących danych: kolumny muszą być liczbowe, w podanym zakresie. */
  if (col_num < 0 || col_num >= mysql_num_fields (res_set))
  {
    print_error (NULL, "Niedozwolony numer kolumny.");
    return;
  }
  mysql_field_seek (res_set, col_num);
  field = mysql_fetch_field (res_set);
  if (!IS_NUM (field->type))
  {
    print_error (NULL, "Kolumna nie jest typu liczbowego.");
    return;
  }

  /* Obliczenie podsumowania danych statystycznych. */

  n = 0;
  missing = 0;
  sum = 0;
  sum_squares = 0;

  mysql_data_seek (res_set, 0);
  while ((row = mysql_fetch_row (res_set)) != NULL)
  {
    if (row[col_num] == NULL)
      missing++;
    else
    {
      n++;
      val = atof (row[col_num]);  /* Konwersja ciągu tekstowego na liczbę. */
      sum += val;
      sum_squares += val * val;
    }
  }
  if (n == 0)
    printf ("Brak obserwacji\n");
  else
  {
    printf ("Liczba obserwacji: %u\n", n);
    printf ("Brakujące obserwacje: %u\n", missing);
    printf ("Suma: %g\n", sum);
    printf ("Średnia: %g\n", sum / n);
    printf ("Suma kwadratów: %g\n", sum_squares);
    var = ((n * sum_squares) - (sum * sum)) / (n * (n - 1));
    printf ("Odchylenie: %g\n", var);
    printf ("Odchylenie standardowe: %g\n", sqrt (var));
  }
}
