# Mając podany identyfikator zdarzenia, procedura wyświetla wyniki dla danego zdarzenia,
# a także wynik minimalny i maksymalny danego zdarzenia, przechowywane w dwóch parametrach OUT.
# Przyjęto założenie, że dostęp będzie się odbywał tylko dla kolumn INT.

DROP PROCEDURE IF EXISTS grade_event_stats;
delimiter $
#@ _PROC_DEFINITION_
CREATE PROCEDURE grade_event_stats
  (IN p_event_id INT, OUT p_min INT, OUT p_max INT)
BEGIN
  -- Wyświetlenie wyników dla danego zdarzenia.
  SELECT student_id, score
    FROM score
    WHERE event_id = p_event_id
    ORDER BY student_id;
  -- Wartości minimalnego i maksymalnego wyniku są przechowywane w parametrach OUT.
  SELECT MIN(score), MAX(score)
    FROM score
    WHERE event_id = p_event_id
    INTO p_min, p_max;
END;
#@ _PROC_DEFINITION_
$
delimiter ;

#@ _PROC_USE_
SET @p_min = NULL, @p_max = NULL; -- Utworzenie zmiennych parametrów.
CALL grade_event_stats(4, @p_min, @p_max);
SELECT @p_min, @p_max;
#@ _PROC_USE_
CALL grade_event_stats(0, @p_min, @p_max); -- Nie będą wygenerowane dane wyjściowe.
SELECT @p_min, @p_max;
