#!/usr/bin/perl
# tabular.pl - Skrypt pozwala na wykonanie zapytania i wyświetla dane wyjściowe w formacie tabeli.

use strict;
use warnings;
use DBI;

# Przyjmuje się założenie, że informacje o komputerze, użytkowniku i haśle będą pobrane z pliku opcji.

my $dsn = "DBI:mysql:sampdb;mysql_read_default_group=client";
my %conn_attrs = (RaiseError => 1, PrintError => 0, AutoCommit => 1);
my $dbh = DBI->connect ($dsn, undef, undef, \%conn_attrs);

#@ _MAIN_BODY_
my $sth = $dbh->prepare (qq{
            SELECT last_name, first_name, suffix, city, state
            FROM president ORDER BY last_name, first_name
          });
$sth->execute (); # Atrybuty powinny być dostępne po tym wywołaniu.

# Rzeczywista maksymalna długość kolumny w zbiorze wynikowym.
my @wid = @{$sth->{mysql_max_length}};
# Liczba kolumn w zbiorze wynikowym.
my $ncols = $sth->{NUM_OF_FIELDS};

# Dostosowanie długości kolumn, jeśli wartości są krótsze niż nagłówki kolumn
# lub niż słowo "NULL" dla kolumn, które akceptują wartości NULL.
for (my $i = 0; $i < $ncols; $i++)
{
  my $name_wid = length ($sth->{NAME}->[$i]);
  $wid[$i] = $name_wid if $wid[$i] < $name_wid;
  $wid[$i] = 4 if $sth->{NULLABLE}->[$i] && $wid[$i] < 4;
}

# Wyświetlenie danych wyjściowych w formacie tabeli.
print_dashes (\@wid, $ncols);             # Wiersz obramowania tabeli.
print_row ($sth->{NAME}, \@wid, $ncols);  # Nagłówki kolumn.
print_dashes (\@wid, $ncols);             # Wiersz obramowania tabeli.
while (my $ary_ref = $sth->fetchrow_arrayref ())
{
  print_row ($ary_ref, \@wid, $ncols);    # Dane rekordu.
}
print_dashes (\@wid, $ncols);             # Wiersz obramowania tabeli.
#@ _MAIN_BODY_

$dbh->disconnect ();

#@ _PRINT_FUNCTIONS_
sub print_dashes
{
my $wid_ary_ref = shift;  # Odniesienie do tablicy zawierającej informacje o szerokości kolumn.
my $cols = shift;         # Liczba kolumn.

  for (my $i = 0; $i < $cols; $i++)
  {
    print "+", "-" x ($wid_ary_ref->[$i]+2);
  }
  print "+\n";
}

# Wyświetlenie rekordu danych (kolumny wartości liczbowych nie zostają wyrównane do prawej strony).

sub print_row
{
my $val_ary_ref = shift;  # Odniesienie do tablicy zawierającej wartości kolumn.
my $wid_ary_ref = shift;  # Odniesienie do tablicy zawierającej informacje o szerokości kolumn.
my $cols = shift;         # Liczba kolumn.

  for (my $i = 0; $i < $cols; $i++)
  {
    printf "| %-*s ", $wid_ary_ref->[$i],
           defined ($val_ary_ref->[$i]) ? $val_ary_ref->[$i] : "NULL";
  }
  print "|\n";
}
#@ _PRINT_FUNCTIONS_
