/*
 * show_opt.c - Program demonstruje przetwarzanie opcji za pomocą funkcji load_defaults() 
 * i handle_options().
 */

#include <my_global.h>
#include <my_sys.h>
#include <mysql.h>
#include <my_getopt.h>

static char *opt_host_name = NULL;    /* Komputer serwera (domyślnie = localhost). */
static char *opt_user_name = NULL;    /* Nazwa użytkownika (domyślnie = nazwa logowania). */
static char *opt_password = NULL;     /* Hasło (domyślnie = brak). */
static unsigned int opt_port_num = 0; /* Numer portu (użyj wbudowanej wartości). */
static char *opt_socket_name = NULL;  /* Nazwa gniazda (użyj wbudowanej wartości). */

static const char *client_groups[] = { "client", NULL };

static struct my_option my_opts[] =   /* Struktury informacji opcji. */
{
  {"help", '?', "Wyświetlenie tego komunikatu pomocy i zakończenie programu.",
  NULL, NULL, NULL,
  GET_NO_ARG, NO_ARG, 0, 0, 0, 0, 0, 0},
  {"host", 'h', "Komputer, z którym chcesz się połączyć.",
  (uchar **) &opt_host_name, NULL, NULL,
  GET_STR, REQUIRED_ARG, 0, 0, 0, 0, 0, 0},
  {"password", 'p', "Hasło.",
  (uchar **) &opt_password, NULL, NULL,
  GET_STR, OPT_ARG, 0, 0, 0, 0, 0, 0},
  {"port", 'P', "Numer portu",
  (uchar **) &opt_port_num, NULL, NULL,
  GET_UINT, REQUIRED_ARG, 0, 0, 0, 0, 0, 0},
  {"socket", 'S', "Ścieżka dostępu do gniazda.",
  (uchar **) &opt_socket_name, NULL, NULL,
  GET_STR, REQUIRED_ARG, 0, 0, 0, 0, 0, 0},
  {"user", 'u', "Nazwa użytkownika.",
  (uchar **) &opt_user_name, NULL, NULL,
  GET_STR, REQUIRED_ARG, 0, 0, 0, 0, 0, 0},
  { NULL, 0, NULL, NULL, NULL, NULL, GET_NO_ARG, NO_ARG, 0, 0, 0, 0, 0, 0 }
};

/* #@ _GET_ONE_OPTION_ */
static my_bool
get_one_option (int optid, const struct my_option *opt, char *argument)
{
  switch (optid)
  {
  case '?':
    my_print_help (my_opts);  /* Wyświetlenie komunikatu pomocy. */
    exit (0);
  }
  return (0);
}
/* #@ _GET_ONE_OPTION_ */

int
main (int argc, char *argv[])
{
int i;
int opt_err;

  printf ("Początkowe parametry połączenia:\n");
  printf ("nazwa komputera: %s\n", opt_host_name ? opt_host_name : "(null)");
  printf ("nazwa użytkownika: %s\n", opt_user_name ? opt_user_name : "(null)");
  printf ("hasło: %s\n", opt_password ? opt_password : "(null)");
  printf ("numer portu: %u\n", opt_port_num);
  printf ("nazwa pliku gniazda: %s\n",
          opt_socket_name ? opt_socket_name : "(null)");

  printf ("Początkowa tablica argumentów:\n");
  for (i = 0; i < argc; i++)
    printf ("arg %d: %s\n", i, argv[i]);

  MY_INIT (argv[0]);
  load_defaults ("my", client_groups, &argc, &argv);

  printf ("Tablica argumentów po wywołaniu funkcji load_defaults():\n");
  for (i = 0; i < argc; i++)
    printf ("arg %d: %s\n", i, argv[i]);

  if ((opt_err = handle_options (&argc, &argv, my_opts, get_one_option)))
    exit (opt_err);

  printf ("Parametry połączenia po wywołaniu funkcji handle_options():\n");
  printf ("nazwa komputera: %s\n", opt_host_name ? opt_host_name : "(null)");
  printf ("nazwa użytkownika: %s\n", opt_user_name ? opt_user_name : "(null)");
  printf ("hasło: %s\n", opt_password ? opt_password : "(null)");
  printf ("numer portu: %u\n", opt_port_num);
  printf ("nazwa pliku gniazda: %s\n",
          opt_socket_name ? opt_socket_name : "(null)");

  printf ("Tablica argumentów po wywołaniu funkcji handle_options():\n");
  for (i = 0; i < argc; i++)
    printf ("arg %d: %s\n", i, argv[i]);

  exit (0);
}
