#!/usr/bin/perl
# show_scores.pl - Skrypt wyświetla wyniki uzyskane przez uczniów we wskazanym dniu.

use strict;
use warnings;
use DBI;

# Przetworzenie parametrów z wiersza poleceń, o ile zostały podane.

use Getopt::Long;
$Getopt::Long::ignorecase = 0; # Wielkość liter w opcjach ma znaczenie.
$Getopt::Long::bundling = 1;   # -uname = -u name, a nie -u -n -a -m -e

# Parametry domyślne, wszystkie początkowo niezdefiniowane.
my ($host_name, $password, $port_num, $socket_name, $user_name);

GetOptions (
  # =i oznacza, że po opcji trzeba podać wartość w postaci liczby całkowitej.
  # =s oznacza, że po opcji trzeba podać wartość w postaci ciągu tekstowego.
  "host|h=s"      => \$host_name,
  "password|p=s"  => \$password,
  "port|P=i"      => \$port_num,
  "socket|S=s"    => \$socket_name,
  "user|u=s"      => \$user_name
) or exit (1);

# Sprawdzenie argumentu wiersza poleceń, proste sprawdzenie formatu.
@ARGV == 1 or die "Nie podano daty\n";
$ARGV[0] =~ /^\d+\D\d+\D\d+$/ or die "Niepoprawna data: $ARGV[0]\n";

# Utworzenie źródła danych.
my $dsn = "DBI:mysql:sampdb";
$dsn .= ";host=$host_name" if $host_name;
$dsn .= ";port=$port_num" if $port_num;
$dsn .= ";mysql_socket=$socket_name" if $socket_name;
$dsn .= ";mysql_read_default_group=client";

# Nawiązanie połączenia z serwerem.
my %conn_attrs = (RaiseError => 1, PrintError => 0, AutoCommit => 1);
my $dbh = DBI->connect ($dsn, $user_name, $password, \%conn_attrs);

my $sth = $dbh->prepare (qq{
            SELECT
              student.name, grade_event.date, score.score, grade_event.category
            FROM
              student INNER JOIN score INNER JOIN grade_event
            WHERE
              student.student_id = score.student_id
              AND score.event_id = grade_event.event_id
              AND grade_event.date = ?
            ORDER BY
              grade_event.date ASC, grade_event.category ASC, score.score DESC
          });
$sth->execute ($ARGV[0]);

# Wyświetlenie nagłówka i ocen.
printf "%-12s  %10s  %5s  %4s\n", "Name", "Date", "Score", "Type";
while (my $hash_ref = $sth->fetchrow_hashref ())
{
  printf "%-12s  %10s  %5s  %4s\n",
         $hash_ref->{name},
         $hash_ref->{date},
         $hash_ref->{score},
         $hash_ref->{category};
}

$dbh->disconnect ();
