/*
 * connect1.c - Nawiązanie połączenia z serwerem MySQL, a następnie jego zamknięcie.
 */

#include <my_global.h>
#include <my_sys.h>
#include <mysql.h>

static char *opt_host_name = NULL;    /* Komputer serwera (domyślnie = localhost). */
static char *opt_user_name = NULL;    /* Nazwa użytkownika (domyślnie = nazwa logowania). */
static char *opt_password = NULL;     /* Hasło (domyślnie = brak). */
static unsigned int opt_port_num = 0; /* Numer portu (użyj wbudowanej wartości). */
static char *opt_socket_name = NULL;  /* Nazwa gniazda (użyj wbudowanej wartości). */
static char *opt_db_name = NULL;      /* Nazwa bazy danych (domyślnie = brak). */
static unsigned int opt_flags = 0;    /* Flagi połączenia (brak). */

static MYSQL *conn;                   /* Wskaźnik do uchwytu połączenia. */

int
main (int argc, char *argv[])
{
  MY_INIT (argv[0]);
  /* Inicjalizacja biblioteki klienta. */
  if (mysql_library_init (0, NULL, NULL))
  {
    fprintf (stderr, "Wywołanie mysql_library_init() zakończyło się niepowodzeniem\n");
    exit (1);
  }
  /* Inicjalizacja uchwytu połączenia. */
  conn = mysql_init (NULL);
  if (conn == NULL)
  {
    fprintf (stderr, "Wywołanie mysql_init() zakończyło się niepowodzeniem (prawdopodobnie z powodu braku pamięci)\n");
    exit (1);
  }
  /* Nawiązanie połączenia z serwerem. */
  if (mysql_real_connect (conn, opt_host_name, opt_user_name, opt_password,
      opt_db_name, opt_port_num, opt_socket_name, opt_flags) == NULL)
  {
    fprintf (stderr, "Wywołanie mysql_real_connect() zakończyło się niepowodzeniem\n");
    mysql_close (conn);
    exit (1);
  }
  /* Zamknięcie połączenia z serwerem i zamknięcie biblioteki klienta. */
  mysql_close (conn);
  mysql_library_end ();
  exit (0);
}
