#!/usr/bin/perl
# chk_mysql_opt_files.pl - Skrypt sprawdza pliki .my.cnf poszczególnych użytkowników
# i gwarantuje, że mają prawidłowe uprawnienia. Właścicielem każdego pliku powinien być
# użytkownik, w którego katalogu domowym znajduje się dany plik. Grupa oraz pozostali
# użytkownicy nie powinni mieć żadnych uprawnień do pliku.

# Skrypt trzeba uruchomić jako użytkownik root.  Dane wejściowe skryptu to plik haseł.
# Jeżeli hasła użytkownika znajdują się w pliku /etc/passwd file, skrypt uruchom
# w następujący sposób:
#  chk_mysql_opt_file.pl /etc/passwd

use strict;
use warnings;

while (<>)
{
  next if /^#/ || /^\s*$/;           # Pominięcie komentarzy, pustych wierszy.
  my ($uid, $home) = (split (/:/, $_))[2,5];
  my $cnf_file = "$home/.my.cnf";
  next unless -f $cnf_file;          # Czy katalog zawiera plik .my.cnf file?
  if ((stat ($cnf_file))[4] != $uid) # Sprawdzenie, kto jest właścicielem pliku.
  {
    warn "Zmiana właściciela pliku $cnf_file na $uid\n";
    chown ($uid, (stat ($cnf_file))[5], $cnf_file);
  }
  my $mode = (stat ($cnf_file))[2];
  if ($mode & 077)                   # Sprawdzenie uprawnień grupy i pozostałych użytkowników.
  {
    warn sprintf ("Zmiana uprawnień %s z %o na %o\n",
                  $cnf_file, $mode, $mode & ~077);
    chmod ($mode & ~077, $cnf_file);
  }
}
