Imports System
Imports System.Collections
Imports System.IO
Imports System.Xml
Imports System.Xml.Serialization
Imports System.Net.Sockets
Imports System.Net
Imports System.Text

Public Class Server
    Public Sub New()
        Dim server As TcpListener = Nothing
        Dim client As TcpClient = Nothing
        Try
            ' Tworzy obiekt nasuchujcy i go uruchamia.
            server = New TcpListener(IPAddress.Parse("127.0.0.1"), 11111)
            server.Start()

            ' Bufor danych wejciowych
            Dim bytes(256) As Byte

            ' Nieskoczona ptla
            While (True)
                ' Zaczyna przyjmowa dane w trybie blokowym.
                client = server.AcceptTcpClient()
                Console.WriteLine("Poczony!")

                ' Otwiera strumie.
                Dim stream As NetworkStream = client.GetStream

                ' Wczytuje wszystkie dane ze strumienia.
                Dim i As Integer
                While ((i = stream.Read(bytes, 0, bytes.Length)) = 0)
                    ' Przygotowuje format do odczytu przez serializer.
                    Dim ms As MemoryStream = New MemoryStream(bytes)
                    ' Przygotowuje serializer.
                    Dim myXmlFactory As XmlSerializer = 
				New XmlSerializer(GetType(CheckingAccount))
                    ' Tworzy obiekt CheckingAccount ze strumienia.
                    Dim myRestoredAccount As CheckingAccount 
                            = CType(myXmlFactory.Deserialize(ms), CheckingAccount)
                    ' Dowd, e obiekt zosta naprawd utworzony.
                    Console.WriteLine("Nazwa: {0}, Numer konta: {1}", _
                        myRestoredAccount.Name, myRestoredAccount.AccountNumber)
                    ' Zgasza wyjtek przerywajcy ptl.
                    Throw New Exception("ignore")
                End While
            End While
        Catch ex As Exception
            If Not ex.Message = "ignore" Then Console.WriteLine("Wyjtek: {0}", ex)
        Finally
            ' Zamyka zasoby
            client.Close()
            server.Stop()
        End Try
        Console.WriteLine("Nacinij dowolny klawisz, aby kontynuowa...")
        Console.ReadKey()
    End Sub
End Class
