using System;
using System.Collections.Generic;
using System.Text;
using System.Net.Sockets;
using System.Net;
using System.Xml;
using System.Xml.Serialization;
using System.IO;
using System.Runtime.Serialization;

namespace Server
{
    class Server
    {
        public Server()
        {
            TcpListener server = null;
            TcpClient client = null;
            try
            {
                // Tworzy obiekt nasuchujcy i zaczyna nasuch.
                server = new TcpListener(IPAddress.Parse("127.0.0.1"), 11111);
                server.Start();

                // Bufor danych wejciowych
                Byte[] bytes = new Byte[256];

                // Nieskoczona ptla
                while (true)
                {
                    // Zaczyna przyjmowa dane w trybie blokowym.
                    client = server.AcceptTcpClient();
                    Console.WriteLine("Poczony!");

                    // Otwiera strumie.
                    NetworkStream stream = client.GetStream();

                    // Odczytuje dane ze strumienia.
                    int i;
                    while ((i = stream.Read(bytes, 0, bytes.Length)) != 0)
                    {
                        // Przygotowuje format do odczytu przez serializer.
                        MemoryStream ms = new MemoryStream(bytes);
                        // Przygotowuje serializer.              
			XmlSerializer myXmlFactory = new XmlSerializer(typeof(CheckingAccount));
                        // Tworzy obiekt CheckingAccount ze strumienia.           
			CheckingAccount myRestoredAccount = (CheckingAccount)myXmlFactory.Deserialize(ms);
                        // Dowd, e obiekt naprawd zosta utworzony.
                        Console.WriteLine("Nazwa: {0}, Numer konta: {1}.",
                            myRestoredAccount.Name, myRestoredAccount.AccountNumber);
                        // Zgasza wyjtek powodujcy wyjcie z ptli.
                        throw new Exception("ignore");
                    }
                }
            }
            catch (Exception ex)
            {
                if (!ex.Message.Equals("ignore")) 
			{ Console.WriteLine("Wyjtek: {0}", ex); } 
            }
            finally
            {
                // Zamyka zasoby.
                client.Close();
                server.Stop();
            }
            Console.WriteLine("Nacinij dowolny klawisz, aby kontynuowa...");
            Console.ReadKey();
        }
    }
}
