// Klasa Person
using System;
using System.Collections;
using System.IO;
using System.Xml;
using System.Xml.Serialization;

namespace CSSerial
{   
    [XmlRoot("person")]
    public class Person
    {
        private String strName;
        private int intAge;
        private int intScore;
        
        public Person()
        {
            this.Name = "John Doe";
            this.Age=25;
            this.Score=50;
        }

        public Person(String name, int age, int score)
        {
            this.Name = name;
            this.Age = age;
            this.Score = score;
        }
        [XmlAttribute("name")]
        public String Name
        {
            get
            {
                return this.strName;
            }
            set
            {
                if (value == null) return;
                this.strName = value;
            }
        }

        [XmlElement("age")]
        public int Age
        {
            get 
            {
                return this.intAge;
            }
            set 
            {
                this.intAge = value;
            }
        }

        [XmlIgnore()]
        public int Score
        {
            get
            {
                return intScore; 
            }
            set 
            {
                this.intScore = value; 
            }
        }
    }
}
