import java.sql.*;

// Listing 9.5 'AddInvoice2.java'

public class AddInvoice2 {

  public static void main(String args[]) throws Exception {

    // Inicjalizacja zmiennych.
    Connection con = null;
    PreparedStatement stmt = null;
    ResultSet rs = null;
    int affected = 0;
    int id = 0;
        
    try {
    
      // Podczenie do MySQL.
      String url = "jdbc:mysql:///finanse";
      Class.forName("com.mysql.jdbc.Driver").newInstance();
      con = DriverManager.getConnection(url, "root", "root");
            
      // Przygotowanie zapytania.
      stmt = con.prepareStatement("INSERT INTO faktury (klient_id, wartosc_faktury, opis_faktury) VALUES (?, ?, ?)");
      
      // Przypisanie wartoci.
      stmt.setInt(1, Integer.parseInt(args[0]));
      stmt.setFloat(2, Float.parseFloat(args[1]));
      stmt.setString(3, args[2]);
      
      // Uruchomienie zapytania.
      affected = stmt.executeUpdate();
      
      // Potwierdzenie, e dziaa zapytanie INSERT.
      if (affected == 1) {
        rs = stmt.getGeneratedKeys();
        rs.next();
        id = rs.getInt(1);
        System.out.println("Zostala utworzona faktura nr " + id + "!");
      } else {
        System.out.println("Faktura nie moze byc dodana do bazy danych!");
      }
    }
    
    // Przechwycenie wyjtkw.
    catch (SQLException e) {
      System.out.println("Problem: " + e.toString());
    }
    
    // Porzdkowanie.
    finally {
      if (rs != null) {
        try {
          rs.close();
        } catch (SQLException e) {
          // Nic nie rb w przypadku wystpienia wyjtku.
        }
        rs = null;
      }
      if (stmt != null) {
        try {
          stmt.close();
        } catch (SQLException e) {
          // Nic nie rb w przypadku wystpienia wyjtku.
        }
        stmt = null;
      }
      if (con != null) {
        try {
          con.close();
        } catch (SQLException e) {
          // Nic nie rb w przypadku wystpienia wyjtku.
        }
      }
    }
    
  } // Koniec main().
  
} // Koniec klasy AddInvoice2.
