import java.sql.*;

// Listing 9.3 'Select.java'

public class Select {
  
  public static void main(String args[]) throws Exception {

    // Inicjalizacja zmiennych.
    Connection con = null;
    Statement stmt = null;
    ResultSet rs = null;
    int id = 0;
    String name = null;
        
    try {
    
      // Podczenie do MySQL.
      String url = "jdbc:mysql:///finanse";
      Class.forName("com.mysql.jdbc.Driver").newInstance();
      con = DriverManager.getConnection(url, "root", "root");
            
      // Uruchomienie zapytania.
      stmt = con.createStatement();
      rs = stmt.executeQuery("SELECT klient_id, nazwa_klienta FROM klienci ORDER BY nazwa_klienta ASC LIMIT 5");
            
      // Pobranie wyniku.
      while (rs.next()) {
        id = rs.getInt(1);
        name = rs.getString("nazwa_klienta");
        
        System.out.println(id + ": " + name);
      }
    }
    
    // Przechwycenie wyjtkw.
    catch (SQLException e) {
      System.out.println("Problem: " + e.toString());
    }
    
    // Porzdkowanie.
    finally {
      if (rs != null) {
        try {
          rs.close();
        } catch (SQLException e) {
          // Nic nie rb w przypadku wystpienia wyjtku.
        }
        rs = null;
      }
      if (stmt != null) {
        try {
          stmt.close();
        } catch (SQLException e) {
          // Nic nie rb w przypadku wystpienia wyjtku.
        }
        stmt = null;
      }
      if (con != null) {
        try {
          con.close();
        } catch (SQLException e) {
          // Nic nie rb w przypadku wystpienia wyjtku.
        }
      }
    }
    
  } // Koniec main().
  
} // Koniec klasy Select.
