#!/bin/bash

# Ten skrypt pokazuje, jak zebrać dane dotyczące ruchu sieciowego w komputerze
# lokalnym.
#
# Przede wszystkim trzeba wskazać interfejs, na którym będzie nasłuchiwany
# ruch sieciowy. Ponieważ interesuje nas ruch lokalny, więc używamy interfejsu
# LOOPBACK. Wydanie polecenia ifconfig w moim komputerze powoduje wygenerowanie
# następujących danych wyjściowych.
#
# > ifconfig
#
# lo: flags=73<UP,LOOPBACK,RUNNING>  mtu 65536
#         inet 127.0.0.1  netmask 255.0.0.0
#         ...
#         ...
#
# Zgodnie z powyższymi danymi wykonanie poniższego polecenia spowoduje
# przechwycenie całego ruchu sieciowego do terminala.
# (Zauważ, że w moim komputerze to wymaga użycia sudo).
sudo tcpdump -i lo -X

# Jeżenie nie znajdujesz interfejsu lokalnego lub chcesz nasłuchiwać na innym,
# wówczas musisz wydać inne polecenie.
#sudo tcpdump -i any -X
