// Przykład z sekcji 2.1.2.
use tutorial

// ******************  2.1.3 Wstawianie i pobieranie danych ******************************
db.users.insert({username: "kowalski"})

db.users.find()

/* Wynik podobny do poniższego: (wartość _id będzie inna).

{ _id : ObjectId("4bf9bec50e32f82523389314"), username : "kowalski" }

*/

db.users.insert({username: "nowak"})

db.users.count()

db.users.find()

/* Wynik podobny do poniższego: (wartość _id będzie inna).

{ _id : ObjectId("4bf9bec50e32f82523389314"), username : "kowalski" }
{ _id : ObjectId("4bf9bec90e32f82523389315"), username : "nowak" }

*/

db.users.find({username: "nowak"})

/* Wynik podobny do poniższego: 
{ _id : ObjectId("4bf9bec90e32f82523389315"), username : "nowak" }
*/


// $or find
db.users.find({ $or: [
  { username: "kowalski" },
  { username: "nowak" }
]})

/* Wynik podobny do poniższego: 
{ _id : ObjectId("4bf9bec50e32f82523389314"), username : "kowalski" }
{ _id : ObjectId("4bf9bec90e32f82523389315"), username : "nowak" }
*/


// *********************** 2.1.4 Uaktualnienie **************************************
db.users.find({username: "kowalski"})
/* Wynik podobny do poniższego:
{ 
  "_id" : ObjectId("4bf9ec440e32f82523389316"),
  "username" : "kowalski"
}

*/

// Operacja uaktualnienia.
db.users.update({username: "kowalski"}, {$set: {country: "Polska"}})

db.users.find({username: "kowalski"})

/* Wynik podobny do poniższego: 
{ 
  "_id" : ObjectId("4bf9ec440e32f82523389316"),
  "country" : "Polska", 
  "username" : "kowalski"
}

*/

// Uaktualnienie, które usuwa nazwę użytkownika - błędne podejście.
db.users.update({username: "kowalski"}, {country: "Polska"})

// Teraz dokument nie ma nazwy użytkownika.
db.users.find({country: "Polska"})

/* Wynik podobny do poniższego
{ 
  "_id" : ObjectId("4bf9ec440e32f82523389316"),
  "country" : "Polska"
}

*/

// Ponowne zdefiniowanie nazwy użytkownika jako kowalski.
db.users.update({country: "Polska"}, {username: "kowalski", country: "Polska"})

// Usunięcia wartości country za pomocą $unset.
db.users.update({username: "kowalski"}, {$unset: {country: 1}})

db.users.find({username: "kowalski"})


// Zdefiniowanie wartości favorites dla użytkownika kowalski.
db.users.update( {username: "kowalski"},
  { 
    $set: {
      favorites: {
        cities: ["Gliwice", "Łódź"],
        movies: ["Casablanca", "Za kilka dolarów więcej", "Żądło"]
     }
    }
  })
  
// Zdefiniowanie wartości favorites dla użytkownika nowak.
db.users.update( {username: "nowak"},
  {
    $set: {
      favorites: {
        movies: ["Casablanca", "Rocky"]
      }
    }
  })

// Sprawdzenie wyników uaktualnienia.
db.users.find().pretty()  // Używamy pretty dla większej czytelności.

//Wyszukanie użytkowników, których ulubionym filmem jest "Casablanca".
db.users.find({"favorites.movies": "Casablanca"}).pretty()

// $addToSet
db.users.update( {"favorites.movies": "Casablanca"},
    {$addToSet: {"favorites.movies": "Sokół maltański} },
          false,   // Wstawić, jeśli element nie został znaleziony?
          true )   // Uaktualnić wszystkie znalezione? (W przypadku wartości false następuje uaktualnienie tylko pierwszego znalezionego).
          
// ****** 2.1.5 Usunięcie danych ********************
db.foo.remove({})

// Usunięcie użytkowników, których ulubionym kinem jest Cheyenne.
db.users.remove({"favorites.cities": "Cheyenne"})


// Usunięcie tabeli users.
db.users.drop()


// *************** 2.1.6 - Inne polecenia *****************************

// Pomoc w konsoli MongoDB.
help

// PRZED uruchomieniem konsoli MongoDB 
// pomoc dotycząca działania polecenia mongo.
mongo --help


// Utworzenie dużej kolekcji.

for(i = 0; i < 200000; i++) {
    db.numbers.save({num: i});
  }

// Sprawdzenie wyników.
db.numbers.count()

db.numbers.find()

db.numbers.find({num: 500})

// Zapytanie zakresu.
db.numbers.find( {num: {"$gt": 199995 }} )

/* Wynik podobny do poniższego 

{ "_id" : ObjectId("4bfbf1dedba1aa7c30afcade"), "num" : 199996 }
{ "_id" : ObjectId("4bfbf1dedba1aa7c30afcadf"), "num" : 199997 }
{ "_id" : ObjectId("4bfbf1dedba1aa7c30afcae0"), "num" : 199998 }

*/

// Górna i dolna granica.
db.numbers.find( {num: {"$gt": 20, "$lt": 25 }} )

/* Wynik podobny do poniższego:
{ "_id" : ObjectId("4bfbf132dba1aa7c30ac831f"), "num" : 21 }
{ "_id" : ObjectId("4bfbf132dba1aa7c30ac8320"), "num" : 22 }
{ "_id" : ObjectId("4bfbf132dba1aa7c30ac8321"), "num" : 23 }
{ "_id" : ObjectId("4bfbf132dba1aa7c30ac8322"), "num" : 24 }

*/
