package Cookbook::DigestAPI;

use Apache;
use Apache::Constants qw (OK DECLINED SERVER_ERROR AUTH_REQUIRED);

use 5.006;
use Digest::MD5;
use DynaLoader;

use strict;

our @ISA = qw(DynaLoader Apache);
our $VERSION = '0.01';

__PACKAGE__->bootstrap($VERSION);

sub new {

  my ($class, $r) = @_;
  
  $r ||= Apache->request;
  
  return bless { r => $r }, $class;
}

sub get_digest_auth_response {
  
  my $r = shift;
  
  return DECLINED unless lc($r->auth_type) eq 'digest';
  
  return SERVER_ERROR unless $r->auth_name;
  
  # Pobierz odpowied na wezwanie Digest.
  my $auth_header = $r->headers_in->get($r->proxyreq ?
                                        'Proxy-Authorization' :
                                        'Authorization');

  # Wysalimy wezwanie Digest, upewnij si,
  # e w odpowiedzi dostalimy rwnie Digest.
  $r->note_digest_auth_failure && return AUTH_REQUIRED
    unless $auth_header =~ m/^Digest/;

  # Przetwrz nagwek i umie go w tablicy asocjacyjnej.
  $auth_header =~ s/^Digest\s+//;
  $auth_header =~ s/"//g;
  
  my %response = map { split(/=/) } split(/,\s*/, $auth_header);
  
  # Upewnij si, e odpowied zawiera wszystkie potrzebne informacje.
  foreach my $key (qw(username realm nonce uri response)) {
    $r->note_digest_auth_failure && return AUTH_REQUIRED
      unless $response{$key};
  }
  
  # Wszystko w porzdku. Ustaw potrzebne informacje
  # w daniu i zwr odpowied do sprawdzenia.
  $r->user($response{username});
  $r->connection->auth_type('Digest');
  
  return (OK, \%response);
}

sub compare_digest_response {
  # Porwnaj tablic asocjacyjn z odpowiedzi get_digest_auth_response
  # z policzonym wczeniej skrtem (np. a3165385201a7ba52a12e88cb606bc76).
  
  my ($r, $response, $digest) = @_;
  
  my $md5 = Digest::MD5->new;
  
  $md5->add(join ":", ($r->method, $response->{uri}));
  
  $md5->add(join ":", ($digest, $response->{nonce}, $md5->hexdigest));
  
  return $response->{response} eq $md5->hexdigest;
}
1;
