package Cookbook::PerlDispatchHandlerHelper;

use Apache::Constants (SERVER_ERROR);

use 5.006;
use Exporter ();

use strict;

our @ISA = qw(Exporter);

our @EXPORT_OK = qw(call_handler);

sub call_handler {

  my ($r, $handler) = @_;

  my $status = undef;

  if (ref $handler eq 'CODE') {
    # Program obsugi jest referencj do kodu, wic wystarczy go uruchomi.
    $status = $handler->($r);
  }
  elsif ((my $sub = $handler) =~ m/sub\s*{/) {
    # Anonimowy podprogram.
    $handler = eval $sub;
    $status = $handler->($r);
  }
  elsif (my ($class, $method) = $handler =~ m/(.*)->(.*)/) {
    # Jawnie okrelony obiektowy program obsugi.
    my $cv = $class->can($method);
    $status = $class->$cv($r) if $cv;
  }
  elsif (my $cv = UNIVERSAL::can(($handler =~ m/(.*)::(.*)/)[0,1])) {
    # Jawnie okrelony program obsugi.
    $status = $cv->($r) if $cv;
  }
  else {
    # Sprawdzamy, czy klasa posiada metod handler().
    $cv = UNIVERSAL::can($handler, 'handler');
    $status = $cv->($r) if $cv;
  }

  $r->log_error('Cookbook::PerlDispatchHandlerHelper: ',
                'nie mg przekaza sterowania do ', $handler) unless defined $status;

  return defined $status ? $status : SERVER_ERROR;
}
1;
