package Cookbook::NNTP;

use Apache::Constants qw(OK);

use Net::NNTP;

use strict;

my %cache = ();

sub handler {
 
  my @servers = Apache->server->dir_config('NNTPhosts');

  # Nawizywanie pocze NNTP w czasie startu procesu potomnego.
  foreach my $server (@servers) {
    $cache{$server} = Net::NNTP->new($server);
  }

  return OK;
}

sub connect_cached {

  my ($self, $server) = @_;

  # Zwracamy poczenie, jeeli istnieje ono dla tego procesu potomnego.
  return $cache{$server} if $cache{$server};

  # W przeciwnym razie nawizujemy je i zapamitujemy.
  return $cache{$server} = Net::NNTP->new($server);
}
1;
