package Cookbook::Multiplex;

use Apache::Constants qw(SERVER_ERROR REDIRECT);
use Apache::File;
use Apache::URI;

use strict;

my @sites = ();

sub handler {

  my $r = shift;

  # Sprawdzamy, czy dane zostay wczytane poprzednio.
  # Jeeli nie - naley je wczyta.
  unless (@sites || read_config()) {
    $r->log_error('Nie mona wczyta listy serwerw zwierciadlanych.');
    return SERVER_ERROR;
  }

  # Tworzymy adres URI dla serwera zwierciadlanego...
  my $site = Apache::URI->parse($r, $sites[rand @sites]);

  # ...i dodajemy dodatkow informacj do cieki.
  $site->path($site->path . $r->path_info);

  # Wykonujemy przekierowanie.
  $r->headers_out->set(Location => $site->unparse);
  return REDIRECT;
}

sub read_config {

  my $conf = Apache->server_root_relative('conf/CPAN.txt');

  my $fh = Apache::File->new($conf);

  unless ($fh) {
    print STDERR "Nie mona otworzy pliku $conf: $!\n";
    return;
  }

  @sites = <$fh>;
  chomp @sites;
  return 1;
}
1;
