package Cookbook::Mail;

use Email::Valid;
use Exporter;
use MIME::Lite;
use MIME::Types;

use 5.6.0;
use strict;

our @ISA = qw(Exporter);
our @EXPORT_OK = qw(send_mail);

sub send_mail {

  my ($r, %args) = @_;

  my $log = $r->server->log;

  # Sprawdzamy, czy podano adres serwera SMTP (jest to konieczne w systemie Win32)
  # i przekazujemy go do moduu MIME::Lite.
  my $smtp_host = delete $args{smtp_host};

  if ($^O =~ m/Win32/ and !$smtp_host) {
    $log->error("Prosz poda adres serwera SMTP.");
    return;
  }

  MIME::Lite->send('smtp', $smtp_host, Timeout => 60) if $smtp_host;

  # Upewniamy si, e podano nagwki From, To i Subject.
  foreach my $header (qw(From To Subject)) {
    unless ($args{$header}) {
      $log->error("Prosz poda nagwek '$header'.");
      return;
    }
  }
 
  # Uywamy moduu Email::Valid do sprawdzenia poprawnoci adresu docelowego.
  unless (Email::Valid->address($args{To})) {
    $log->error("$args{To} nie wyglda jak poprawny adres.");
    return;
  }
   
  # Upewniamy si, e podano tre listu w formie parametru
  # Data (skalar albo referencja do tablicy), Path (nazwa pliku)
  # albo FH (uchwyt pliku).
  unless (grep { $args{$_} } qw(Data Path FH)) {
    $log->error("Prosz poda parametr 'Data', 'Path', albo 'FH' jako tre listu.");
    return;
  }

  # Sprawdzamy, czy istnieje zacznik.
  my $attachment = delete $args{attachment};

  # Tworzymy podstawow tre listu.
  my $msg = MIME::Lite->new(%args, Type => 'TEXT');

  # Jeeli istnieje zacznik, dodajemy go, uywajc moduu MIME::Types
  # do ustawienia odpowiedniej wartoci nagwka Content-Type.
  if ($attachment) {
    if (-r $attachment->{file}) {
      my ($type, $encoding) = MIME::Types::by_suffix($attachment->{name});
      $msg->attach(Path => $attachment->{file},
                   Filename => $attachment->{name},
                   Type => $type);
    }
    else {
      $log->error("Nie mona czyta pliku ", $attachment->{name});
      return;
    }
  }

  # Wysyamy list.
  unless ($msg->send ) {
    $log->error("Nie mona wysa listu.");
    return;
  }
 
  return 1;
}
1;
