package Cookbook::HTMLTemplate;

use Apache::Constants qw(OK DECLINED SERVER_ERROR);

use HTML::Template;

use strict;

sub handler {

  my $r = shift;

  my $log = $r->server->log;

  return DECLINED unless $r->content_type eq 'text/html';

  # Otwieramy plik, zawierajcy dany szablon.
  my $template = HTML::Template->new(filename => $r->filename);

  unless ($template) {
    $r->warn("Nie mona otworzyc pliku - pomijamy...");
    return DECLINED;
  }

  # Ustawiamy tablic zmiennych rodowiskowych do wypisania w ptli.
  my @env_loopvals = map { {key=>$_, val=>$ENV{$_}} } keys %ENV;

  $template->param(env_vals => \@env_loopvals);

  # Ustawiamy pojedyncz zmienn dla szablonu.
  $template->param(user => $r->user);

  $r->send_http_header('text/html');
  $r->print($template->output);

  return OK;
}
1;
