package Cookbook::CacheWeather;

use Apache::Constants qw(OK NOT_FOUND);

use Cookbook::CacheContent;

use strict;

@Cookbook::CacheWeather::ISA = qw(Cookbook::CacheContent);

sub ttl {

  my($self, $r) = @_;

  my $uri = $r->uri;

  return(60)      if ($uri=~ /hourly\.html$/);
  return(60 * 24) if ($uri=~ /daily\.html$/);
  return $self->SUPER::ttl($r);
}

sub handler ($$) {

  my ($self,$r) = @_;

  # Odnajdujemy parametry w adresie URL...
  my ($city, $period) = $r->uri =~ m!/(.*?)_(hourly|daily)\.html$!;

  return NOT_FOUND unless ($city and $period);

  my $time = localtime;
  my $report = ($period eq 'hourly') ? "godzinny" : "dobowy";

  $r->send_http_header('text/html');
  print<<EOF;
    <html>
      <body>
        <h1>Pogoda dla miasta $city - Raport $report</h1>
        Jest sonecznie, temperatura 25&deg;C o godzinie $time.
      </body>
    </html>
EOF

  return OK;
}
1;
