package Cookbook::CPANInstall;

use Apache::Constants qw(OK DECLINED);

use strict;

sub handler {

  my $r = shift;

  my $dist;

  # Odmawiamy obsugi, jeeli danie nie dotyczy dystrybucji.
  return DECLINED unless
    ($dist = $r->uri) =~ s!.*authors/id/(.*)\.(tar\.gz|tgz|zip)$!$1.$2!;

  # Zapamitujemy nazw dystrybucji.
  $r->notes(DIST => $dist);

  # Ustawiamy program obsugi generowania zawartoci na send_name.
  $r->handler('perl-script');
  $r->set_handlers(PerlHandler => [\&send_name]);

  return OK;
}

sub send_name {

  my $r = shift;

  # Zmieniamy typ MIME.
  $r->content_type('application/x-cpan');

  # Ustawiamy nazw pliku do zapisania jako 'dist.CPAN'.
  $r->headers_out->set('Content-Disposition' =>
                       'inline; filename=dist.CPAN');

  # Wysyamy nazw dystrybucji.
  $r->send_http_header;
  $r->print($r->notes('DIST'));

  return OK;
}
1;
