package Cookbook::WormsBeGone;

use Apache::Constants qw (OK FORBIDDEN DECLINED SERVER_ERROR);

use strict;

sub handler {

  my $r = shift;

  my $ip  = $r->connection->remote_ip;
  my $uri = $r->uri;

  my $bad_ip_dir = $r->dir_config->get('BadIPDir');
  my @bad_urls   = $r->dir_config->get('BadURLs');

  # Zakocz dziaanie, jeeli nie zdefiniowano katalogu.
  return DECLINED unless ($bad_ip_dir);
  return FORBIDDEN if (-f "$bad_ip_dir/$ip");

  foreach my $bad_url (@bad_urls) {
    if (index($uri, $bad_url) == 0) {
      # danie pochodzi od robaka internetowego lub intruza.
      # Utwrz plik dla tego adresu IP.
      open(TOUCHFILE, ">$bad_ip_dir/$ip") or return SERVER_ERROR;
      close(TOUCHFILE);
      return FORBIDDEN;
    }
  }

  return OK;
}
1;
