package Cookbook::PassLocalIP;

use Apache::Constants qw (OK);

use strict;

sub handler {

  my $r = shift;
  
  # Nie trzeba nic robi, jeeli Apache i tak
  # nie zamierza przeprowadzi identyfikacji.
  return OK unless $r->some_auth_required;
  
  # Pobierz list dozwolonych masek adresw IP.
  my @IPlist = $r->dir_config->get('PassIP');
  
  if (grep {$r->connection->remote_ip =~ m/^\Q$_/} @IPlist) {
    # Wycz identyfikacj, jeeli danie nadeszo z uprawnionego adresu IP...
    $r->set_handlers(PerlAuthenHandler => [\&OK]);
    
    # ...oraz autoryzacj, jeeli rwnie jest skonfigurowana.
    $r->set_handlers(PerlAuthzHandler => [\&OK])
      if grep { lc($_->{requirement}) ne 'valid-user' } @{$r->requires};
  }
  
  return OK;
}
1;
