package Cookbook::AuthzRole;

use Apache::Constants qw (OK AUTH_REQUIRED);

use DBI;

use strict;

sub handler {

  my $r = shift;
  
  my $dbuser = $r->dir_config('DBUSER');
  my $dbpass = $r->dir_config('DBPASS');
  my $dbase  = $r->dir_config('DBASE');
  
  # Zakocz, jeeli nie podano uytkownika do sprawdzenia.
  my $user = $r->user
    or $r->note_basic_auth_failure && return AUTH_REQUIRED;
    
  foreach my $requires (@{$r->requires}) {
    my ($directive, @list) = split " ", $requires->{requirement};
    
    # OK, jeeli wymagany tylko valid-user.
    return OK if lc($directive) eq 'valid-user';
    
    # OK, jeeli wymagany jest uytkownik i moemy go dopasowa
    # na podstawie tego, co ju wiemy.
    return OK if lc($directive) eq 'user' && grep { $_ eq $user } @list;
    
    # A teraz waciwa praca - autoryzacja na podstawie roli w bazie
    # danych Oracle. Poniszy kod obsuguje wpis w httpd.conf podobny do:
    # Require group DBA
    if ($directive eq 'group') {
      my $dbh = DBI->connect($dbase, $dbuser, $dbpass,
        {RaiseError => 1, PrintError => 1}) or die $DBI::errstr;
        
      my $sql = qq(
         select grantee
           from dba_role_privs
           where grantee = UPPER(?)
           and   granted_role = UPPER(?)
      );
      
      my $sth = $dbh->prepare($sql);
      
      foreach my $role (@list) {
        $sth->execute($r->user, $role);
        
        my ($ok) = $sth->fetchrow_array;
        
        $sth->finish;
        
        return OK if $ok;
      }
    }
  }
  
  # adne kryterium nie zostao spenione, uytkownik nie przeszed autoryzacji.
  $r->note_basic_auth_failure;
  return AUTH_REQUIRED;
}
1;
