package My::Authenticate;

use Apache::Constants qw (OK FORBIDDEN DECLINED SERVER_ERROR);

# Modu podobny do uytego w rozdziale 10.
use My::Utils qw(authenticate_user);

use strict;

sub handler {

  my $r = shift;

  # Przepu, jeeli jest to danie wewntrzne.
  return DECLINED unless $r->is_initial_req;
  
  # Pobierz dane dostarczone przez klienta.
  my ($status, $password) = $r->get_basic_auth_pw;
  
  return $status unless $status == OK;
  
  # Przeprowad wasne sprawdzenie uytkownika i hasa.
  return OK if authenticate_user($r->user, $password);
  
  # Ojej, ze haso.
  $r->note_basic_auth_failure;
  return AUTH_REQUIRED;
}
1;
