package Cookbook::URISessionManager;

use Apache::Constants qw(DECLINED OK);
use Apache::URI;

use strict;

sub get_session {
  # Pobieramy identyfikator sesji z adresu URL.

  my $r = shift;

  my $uri = $r->parsed_uri;

  # Oddzielamy sesj MD5 od rzeczywistej cieki.
  my ($session, $path) = $uri->path =~ m!^/([a-fA-F0-9]{32})(/.*)!;
  
  return DECLINED unless $session;

  # Zapisujemy identyfikator sesji dla pozostaych programw obsugi...
  $r->notes(SESSION => $session);

  # ...i ustawiamy adres URI na odpowiedni ciek.
  $r->uri($path);

  return DECLINED;
}

sub clean_uri {
  # Przejcie do podanego adresu URL tak, by nagwek Referer 
  # nie wyciek do innych serwisw.

  my $r = shift;

  my ($uri) = $r->uri =~ m!.*(http://.*)!;

  $r->send_http_header('text/html');

  print<<EOF;
<html>
  <head>
    <meta http-equiv="refresh" content="0;URL=$uri">
  </head>
  <body>
    powiniene ju by <a href="$uri">tutaj</a>
  </body>
</html>
EOF

  return OK;
}
1;
