package Cookbook::TrapNoHost;

use Apache::Constants qw(DECLINED BAD_REQUEST);
use Apache::URI;

use strict;

sub handler {

  my $r = shift;

  # Prawidowe dania do serwerw wirtualnych musz zawiera:
  # nagwek Host, lub
  # bezwzgldny adres URI.

  unless ($r->headers_in->get('Host') || $r->parsed_uri->hostname) {

    $r->custom_response(BAD_REQUEST, 
                        "Ojej! W twoim daniu brakuje nagwka Host!");

    return BAD_REQUEST;
  }

  return DECLINED;
}
1;
