package Cookbook::MirrorApache;

use Apache::Constants qw(OK DECLINED);

use strict;

sub handler {

  my $r = shift;

  return DECLINED unless $r->proxyreq;

  my (undef, $file) = $r->uri =~ m!^http://(www|httpd).apache.org/(.*)!;

  return DECLINED unless $file;

  if ($file =~ m!^docs/!) {
    # Zamieniamy dania do dokumentacji na wersje lokalne.

    $file =~ s!^docs/!manual/!;

    $file = join "/", ($r->document_root, $file);

    if (-f $file) {
      # Uywamy pliku lokalnego...
      $r->filename($file);

      # ...i czycimy znacznik proxy, aby serwer Apache uruchomi
      # faz okrelania typu MIME.
      $r->proxyreq(0);

      return OK;
    }
    # Plik nie by lokalny, wic przechodzimy dalej...
  }
  elsif ($file =~ m!^dist/!) {
    # Zamiast serwera apache.org uyjemy serwera zwierciadlanego.

    my @mirrors = $r->dir_config->get('ApacheDistMirror');

    # Ojej, nie skonfigurowalimy listy serwerw zwierciadlanych?
    return DECLINED unless @mirrors;

    $file =~ s!^dist/!!;

    $r->filename(join "", ("proxy:", $mirrors[rand @mirrors], $file));

    return OK;
  }

  return DECLINED;
}
1;
