package Cookbook::MarkPhases;

use Apache::Constants qw(OK DECLINED);

use strict;

sub handler {
  # Dodajemy program obsugi dla kadej fazy, aby zaznaczy jej zakoczenie.
  # Pomijamy PerlHandler, gdy w poczeniu z moduami Apache::Registry
  # i mod_dir powoduje konflikty.

  my $r = shift;

  foreach my $handler (qw(PerlPostReadRequestHandler PerlHeaderParserHandler
                          PerlTransHandler PerlAccessHandler PerlAuthenHandler
                          PerlAuthzHandler PerlTypeHandler PerlFixupHandler
                          PerlLogHandler PerlCleanupHandler)) {

    $r->push_handlers($handler => sub {
      my $r = shift;

      my $phase = $r->current_callback;

      print STDERR "***Zakoczono przetwarzanie fazy $phase\n";

      # Zwracamy warto DECLINED, aby unikn konfliktw w niektrych fazach.
      return DECLINED;
    });
  }
  return OK;
}
1;
