package Cookbook::Authenticate;

use Apache::Constants qw(REDIRECT);
use Apache::AuthCookie;

# Implementacj poniszego moduu autoryzujcego pozostawiamy czytelnikowi
use Cookbook::Utils qw(authenticate_user authenticate_session); 

use strict;

@Cookbook::Authenticate::ISA = qw(Apache::AuthCookie);

sub authen_cred {
  # Sprawdzamy tosamo uytkownika na podstawie przekazanych danych
  # i zwracamy identyfikator sesji lub warto undef w przypadku bdu.

  my ($self, $r, $user, $password) = @_;

  my $session = authenticate_user($user, $password);

  return $session;
}

sub authen_ses_key {
  # Sprawdzamy poprawno identyfikatora sesji i zwracamy
  # nazw uytkownika lub warto undef w przypadku bdu.

  my ($self, $r, $session) = @_;

  my $user = authenticate_session($session);

  return $user;
}

sub logout ($$) {
  # Wywoujemy metod Apache::AuthCookie::logout(), aby pozby si wszelkich
  # danych uytkownika, a nastpnie przekierowujemy go na odpowiedni stron.

  my ($self, $r) = @_;

  $self->SUPER::logout($r);

  $r->headers_out->set(Location => '/logged-out.html');

  return REDIRECT;
}
1;
