package Custom::RefBlock;

use Apache::Constants qw(OK);

use strict;

sub handler {
  # Naley uy jako PerlInitHandler, aby zastpi ustawienia z httpd.conf,
  # jeeli danie pochodzi z lokalnego adresu IP.
  # Znacznik RefBlockDebug przyjmuje wartoci 0 (wyczone) lub 1 (wczone).

  my $r = shift;

  if ($r->connection->remote_ip =~ m/^10.3.4/) {
    # Pobieramy dane konfiguracyjne.
    my $cfg = Apache::ModuleConfig->get($r, 'Apache::RefererBlock');

    # Trick: zapisujemy star warto i pobieramy now.
    (my $old_debug, $cfg->{debug}) = ($cfg->{debug}, 1);

    # Upewniamy si, e stare ustawienie zostanie przywrcone.
    $r->push_handlers(PerlCleanupHandler =>
                      sub { $cfg->{debug} = $old_debug });
  }
  return OK;
}
1;
