package Cookbook::Clean;

use Apache::Constants qw( OK DECLINED );
use Apache::File;
use Apache::Log;

use HTML::Clean;

use strict;

sub handler {
  
  my $r = shift;

  my $log = $r->server->log;

  unless ($r->content_type eq 'text/html') {
    $log->info("danie nie dotyczy dokumentu HTML - pomijamy...");
    return DECLINED; 
  }

  my $fh = Apache::File->new($r->filename);

  unless ($fh) {
    $log->warn("Nie mona otworzy danego pliku - pomijamy... $!");
    return DECLINED;
  }

  # Wczytujemy cay plik (miejmy nadziej, e nie jest zbyt duy).
  my $dirty = do {local $/; <$fh>};

  # Tworzymy nowy obiekt HTML::Clean.
  my $h = HTML::Clean->new(\$dirty);

  # Ustawiamy poziom "czystoci".
  $h->level(3);

  # Czycimy kod HTML.
  $h->strip;

  # Wysyamy oczyszczone dane.
  $r->send_http_header('text/html');
  print ${$h->data};

  return OK;
}
1;
__END__

=head1 NAME

Cookbook::Clean - program obsugi serwera Apache, ktry oczyszcza kod HTML ze mieci

=head1 SYNOPSIS

DocumentRoot /usr/local/apache/htdocs

PerlModule Cookbook::Clean
<Directory /usr/local/apache/htdocs>
  SetHandler perl-script
  PerlHandler Cookbook::Clean
</Directory>

=head1 DESCRIPTION

Oczyszcza kod HTML, usuwajc niepotrzebne biae znaki i niepotrzebne dane. 
Tak naprawd jest to tylko interfejs do moduu HTML::Clean.

=cut
