package Cookbook::XBitHack;

use Apache::Constants qw(OK DECLINED OPT_INCLUDES);
use Apache::File;

use Fcntl qw(S_IXUSR S_IXGRP);

use strict;

sub handler {
  # Implementujemy dyrektyw "XBitHack full" w programie PerlFixupHandler.

  my $r = shift;

  return DECLINED unless
    (-f $r->finfo                    &&    # plik istnieje
     $r->content_type eq 'text/html' &&    # i jest dokumentem HTML
     $r->allow_options & OPT_INCLUDES);    # i ustawiono opcj +Includes

  # Sprawdzamy, czy plik jest wykonywalny dla waciciela i jego grupy.
  my $mode = (stat _)[2];

  # Wykonywalno dla waciciela musimy sprawdzi osobno.
  return DECLINED unless ($mode & S_IXUSR);
   
  # Ustawiamy nagwek Last-Modified, jeeli plik jest wykonywalny dla grupy.
  $r->set_last_modified((stat _)[9]) if ($mode & S_IXGRP);

  # Upewniamy si, e modu mod_include zajmie si daniem.
  $r->handler('server-parsed');

  return OK;
}
1;
