package Cookbook::WinBitHack;

use Apache::Constants qw(OK DECLINED OPT_INCLUDES);
use Apache::File;

use Win32::File qw(READONLY ARCHIVE);

use strict;

sub handler {
  # Implementujemy dyrektyw "XBitHack full" w programie PerlFixupHandler,
  # wersja dla systemu Win32.

  my $r = shift;

  return DECLINED unless (
     -f $r->finfo                    &&    # plik istnieje
     $r->content_type eq 'text/html' &&    # i jest dokumentem HTML
     $r->allow_options & OPT_INCLUDES);    # i ustawiono opcj +Includes

  # Pobieramy atrybuty pliku.
  my $attr;
  Win32::File::GetAttributes($r->filename, $attr);

  # Zwracamy sta DECLINED, jeeli plik ma ustawiony atrybut ARCHIVE.
  return DECLINED if $attr & ARCHIVE;

  # Ustawiamy nagwek Last-Modified, jeeli nie jest ustawiony atrybut READONLY.
  $r->set_last_modified((stat _)[9]) unless $attr & READONLY;

  # Upewniamy si, e modu mod_include zajmie si daniem.
  $r->handler('server-parsed');

  return OK;
}
1;
