package Cookbook::SubRequestContent;

use Apache::Table;
use Apache::URI;
use HTTP::Request;
use LWP::UserAgent;

use strict;

sub new {
  # Konstruktor obiektu Cookbook::SubRequestContent.
  # Uycie: my $sub = Cookbook::SubRequestContent->new($relative_uri);

  my ($caller, $subrequest) = @_;

  # Pozwalamy dziedziczy po naszej klasie, eby pniej mona byo
  # doda dodatkow funkcjonalno.
  my $class = ref($caller) || $caller;

  my $self = { _subrequest => $subrequest };

  # Nadajemy klas nowemu obiektowi.
  bless $self, $class;

  # Przeprowadzamy niezbdn inicjalizacj.
  $self->_init;

  # Koniec, moemy zwrci obiekt.
  return $self;
}

sub _init {
  # Inicjalizacja.

  my $self = shift;

  my $r = Apache->request;

  # Tworzymy nowy adres URI w oparciu o aktualne danie
  # i adres wzgldny, przekazany jako parametr do metody new().
  my $uri = Apache::URI->parse($r);
  $uri->path($self->{_subrequest});
 
  # Tworzymy nowy obiekt HTTP::Request.
  $self->{_request} = HTTP::Request->new(GET => $uri->unparse);

  # Tworzymy obiekt Apache::Table do przechowywania nagwkw.
  my $table = Apache::Table->new($r);

  # Wypeniamy tablic nagwkw naszego dania wewntrznego wartociami
  # nagwkw aktualnego dania, tak jak w prawdziwym daniu wewntrznym.
  $r->headers_in->do(sub {
    $table->set(@_);
    1;
  });
  
  # Zapamitujemy obiekt Apache::Table w naszym obiekcie.
  $self->{_headers_in} = $table;
}

sub headers_in {
  # Zwracamy obiekt Apache::Table zawierajcy nagwki.
  # Uycie: $sub->headers_in->set('Accept-Language' => 'pl');

  return shift->{_headers_in};
}

sub status {
  # Zwracamy status dania.
  # Normalny obiekt dania wewntrznego pozwala nam sprawdzi status przed
  # wywoaniem run(), wic jeeli nie zostaa jeszcze wygenerowana zawarto,
  # to wywoujemy run().

  my $self = shift;

  $self->run unless $self->{_response};

  return $self->{_response}->code;
}

sub run {
  # Uruchamia danie wewntrzne.

  my $self = shift;

  # Jeeli wywoywalimy metod status(), to zawarto jest ju wygenerowana.
  return $self->{_content} if $self->{_content};

  my $request = $self->{_request};

  # Wstawiamy nagwki do dania.
  $self->{_headers_in}->do(sub {
    $request->header(@_);
    1;
  });

  # Przesyamy danie do serwera i pobieramy odpowied.
  my $response = LWP::UserAgent->new->request($request);

  # Zapamitujemy obiekt HTTP::Response w naszym obiekcie.
  $self->{_response} = $response;

  # Zapamitujemy zawarto w naszym obiekcie.
  $self->{_content} = $response->content;

  return $self->{_content};
}
1;
