package Cookbook::Multiplex;

use Apache::File;
use Apache::URI;
use Apache::Constants qw(SERVER_ERROR REDIRECT);

use strict;

sub handler {

  my $r = shift;

  # Pobieramy <Location>.
  (my $location = $r->location) =~ s!^/!!;

  my $conf = $r->server_root_relative("conf/$location.txt");

  # Otwieramy plik konfiguracyjny.
  my $fh = Apache::File->new($conf);

  unless ($fh) {
    $r->log_error("Nie mona otworzy $conf: $!");
    return SERVER_ERROR;
  }

  my @sites = <$fh>;
  chomp @sites;

  # Tworzymy adres URI dla serwera lustrzanego...
  my $uri = Apache::URI->parse($r, $sites[rand @sites]);

  # ... i dodajemy dodatkowe informacje.
  $uri->path($uri->path . $r->path_info);

  # Wykonujemy przekierowanie.
  $r->headers_out->set(Location => $uri->unparse);
  return REDIRECT;
}
1;
