package Cookbook::ExportUtil;

use DynaLoader;
use Exporter;

use strict;

our @ISA = qw(Exporter);

our @EXPORT_OK = qw(unescape_uri unescape_uri_info escape_html
                    validate_password size_string);

# Ponisze metody wymagaj rodowiska serwera Apache, wic
# nie pozwalamy ich eksportowa.
our @EXPORT_NOT_OK = qw(escape_uri ht_time parsedate);

my $libref = 
  DynaLoader::dl_load_file("/usr/local/apache/libexec/libhttpd.so");

my $symref = DynaLoader::dl_find_symbol($libref, 
                                        "boot_Apache__Util");

my $coderef = DynaLoader::dl_install_xsub("Apache::Util::bootstrap", 
                                          $symref);

Apache->$coderef;

# Teraz robimy to samo z klas Apache, eby uzyska dostp do 
# unescape_uri() i unescape_url().
$symref = DynaLoader::dl_find_symbol($libref, 
                                     "boot_Apache");

$coderef = DynaLoader::dl_install_xsub("Apache::bootstrap", 
                                       $symref);

Apache->$coderef;

# Wreszcie moemy zaimportowa symbole, ktrych uywa nasza klasa.
use  Apache::Util qw(unescape_uri unescape_uri_info escape_html
                     validate_password size_string);