package Cookbook::Userdir;

# Prosty PerlTransHandler, ktry naladuje mod_userdir.

use Apache::Constants qw(OK DECLINED);

use strict;

sub handler {

  my $r = shift;

  # Zapamitujemy poprzednie ustawienie DocumentRoot.
  my $old_docroot = $r->document_root;

  # Musimy si troch pogimnastykowa, aby pomc moduowi mod_dir.
  if (my ($user, $path) = $r->uri =~ m!^/~      # Zaczyna si od ukonika i tyldy.
                                       ([^/]+)  # Jeden lub wicej znakw, ktre
                                                # nie s ukonikiem.
                                       /?       # Zero albo jeden kocowy ukonik.
                                       (.*)     # Caa reszta.
                                      !x) {
    # Ustawiamy now warto DocumentRoot.
    $r->document_root("/home/$user/public_html");

    # Ustawiamy URI na ciek bez nazwy uytkownika.
    $r->uri("/$path");

    # Ustawiamy program obsugi, ktry przywrci poprzednie ustawienie DocumentRoot
    # w fazie sprztania po daniu.
    $r->push_handlers(PerlCleanupHandler =>
                        sub {
                          shift->document_root($old_docroot);
                          return OK;
                        }
                     );
  }

  return DECLINED;

}
1;
