package Cookbook::SSLStatus;

use Apache::URI;

use strict;

# Dodajemy pozycj w menu skryptu perl-status pokazujc, 
# czy uruchomiono obsug SSL.
# Opieramy si na opcji -DSSL z wiersza polece, gdy taka
# jest konwencja...

if (Apache->module('Apache::Status')) {
  Apache::Status->menu_item('SSL',
                            'SSL status',
                            \&status);

  sub status {
    my $r = shift;

    my $ssl = $r->define('SSL');

    my @string = ("Serwer Apache zosta uruchomiony ",
                  $ssl ? "z opcj " : "bez opcji ",
                  "-DSSL");

    if ($ssl) {
      my $uri = Apache::URI->parse($r);
   
      $uri->scheme('https');

      my $new_uri = $uri->unparse;

      push @string, qq!<br><a href="$new_uri">
                       Id do strony przez poczenie bezpieczne.</a>
                      !;
    }

    return \@string;
  }
}
1;
