package Cookbook::PrintUploads;

use Apache::Constants qw(OK);
use Apache::Request;
use Apache::Util qw(escape_html);

use strict;

sub handler {

  # Standardowe wywoanie, z kilkoma nowymi opcjami...
  my $r = Apache::Request->new(shift,
                               POST_MAX => 10 * 1024 * 1024, # w bajtach, czyli 10M
                               DISABLE_UPLOADS => 0);

  my $status = $r->parse();

  # Zwracamy kod bdu, jeeli wystpi problem.
  return $status unless $status == OK;

  $r->send_http_header('text/html');

  $r->print("<html><body>\n");
  $r->print("<h1>Wysyanie plikw</h1>");

  # Ptla po wszystkich wysanych plikach.
  foreach my $upload ($r->upload) {
    my $filename    = $upload->filename;
    my $filehandle  = $upload->fh;
    my $size        = $upload->size;

    $r->print("Wysano plik o nazwie $filename, $size bajtw<br>");
    $r->print("Pierwsza linia tego pliku to: <br>");
    my $line = <$filehandle>;
    $r->print(escape_html($line), "<br>");
  }
  $r->print("Koniec......<br>");

  # Tworzymy prosty formularz.
  $r->print(<<EOF);
  <form enctype="multipart/form-data" name="files" action="/upload" method="POST">
    Plik 1 <input type="file" name="file1"><br>
    Plik 2 <input type="file" name="file2"><br>
    Plik 3 <input type="file" name="file3"><br><br>
    <input type="submit" name="submit" value="Wylij te pliki">
  </form>
 </body></html>
EOF

  return OK;
};
1;
